(function(){

//=============================================================================
// Scene_Map
//=============================================================================

Scene_Map.prototype.updateEncounterEffect = function() {
  if (this._encounterEffectDuration > 0) {
    this._encounterEffectDuration--;
    var speed = this.encounterEffectSpeed();
    var n = speed - this._encounterEffectDuration;
    if (n === 2) {
      this.snapForBattleBackground();
      this.startFlashForEncounter(12);
    }
    if (n === Math.floor(speed / 2)) {
      BattleManager.playBattleBgm();
    }
  }
};

Scene_Map.prototype.encounterEffectSpeed = function() {
    return 12;
};

Scene_Map.prototype.stopAudioOnBattleStart = function() {
  var battleBgm = $gameSystem.battleBgm();
  var troop = $dataTroops[$gameTroop._troopId];
  if (troop.specificBgm.name !== undefined) {
    battleBgm = troop.specificBgm;
  }
  if (!AudioManager.isCurrentBgm(battleBgm)) {
    AudioManager.stopBgm();
  }
  AudioManager.stopBgs();
  AudioManager.stopMe();
  AudioManager.stopSe();
};

//=============================================================================
// Scene_Battle
//=============================================================================

Scene_Battle.prototype.startFadeIn = function() {
};

Scene_Battle.prototype.startFadeOut = function() {
};

//=============================================================================

}());
